/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.AnimationType;
import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.ScheduledAnimation;
import lib.toma.animations.engine.Schedule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.profiler.IProfiler;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class AnimationPipeline
implements IAnimationPipeline {
    private final Marker MARKER = MarkerManager.getMarker((String)"Pipeline");
    private final Map<AnimationType<?>, IAnimation> playingAnimations = new TreeMap();
    private final List<Schedule<ScheduledAnimation<?>>> scheduledAnimations = new ArrayList();

    @Override
    public <A extends IAnimation> void insert(AnimationType<A> type) {
        if (!type.hasCreator()) {
            AnimationEngine.logger.fatal(this.MARKER, "Cannot create default animation from animation type ({}) with undefined AnimationCreator", type);
        }
        A animation = type.create((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        this.insert(type, animation);
    }

    @Override
    public <A extends IAnimation> void insert(AnimationType<A> type, A animation) {
        if (animation == null) {
            AnimationEngine.logger.fatal(this.MARKER, "Attempted to play null animation for {} type, aborting!", type);
            return;
        }
        this.playingAnimations.put(Objects.requireNonNull(type), animation);
    }

    @Override
    public <A extends IAnimation> void scheduleInsert(AnimationType<A> type, int gameTickDelay) {
        if (!type.hasCreator()) {
            AnimationEngine.logger.fatal(this.MARKER, "Cannot create default animation from animation type ({}) with undefined AnimationCreator", type);
        }
        this.scheduleInsert(type, type.create((PlayerEntity)Minecraft.func_71410_x().field_71439_g), gameTickDelay);
    }

    @Override
    public <A extends IAnimation> void scheduleInsert(AnimationType<A> type, A animation, int gameTickDelay) {
        if (gameTickDelay < 0) {
            throw new IllegalArgumentException("Delay must be bigger than 0!");
        }
        if (animation == null) {
            AnimationEngine.logger.fatal(this.MARKER, "Attempted to schedule null animation for {} type", type);
            return;
        }
        if (gameTickDelay == 0) {
            this.insert(type, animation);
        } else {
            this.scheduledAnimations.add(new Schedule<ScheduledAnimation>(gameTickDelay, () -> new ScheduledAnimation<IAnimation>(Objects.requireNonNull(type), animation)));
        }
    }

    @Override
    public void remove(AnimationType<?> type) {
        this.playingAnimations.remove(type);
    }

    @Override
    public void removeScheduled(AnimationType<?> type) {
        this.scheduledAnimations.removeIf(schedule -> ((ScheduledAnimation)schedule.get()).getType().getKey().equals((Object)type.getKey()));
    }

    @Override
    public <A extends IAnimation> A get(AnimationType<A> type) {
        return (A)this.playingAnimations.get(type);
    }

    @Override
    public boolean has(AnimationType<?> type) {
        return this.playingAnimations.containsKey(type);
    }

    @Override
    public boolean hasScheduled(AnimationType<?> type) {
        for (Schedule<ScheduledAnimation<?>> schedule : this.scheduledAnimations) {
            ScheduledAnimation<?> animation = schedule.get();
            if (!animation.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleGameTick() {
        IProfiler profiler = Minecraft.func_71410_x().func_213239_aq();
        profiler.func_76320_a("animationTick");
        profiler.func_76320_a("scheduledTick");
        this.tickScheduled();
        profiler.func_219895_b("activeTick");
        Iterator<IAnimation> it1 = this.playingAnimations.values().iterator();
        while (it1.hasNext()) {
            IAnimation animation = it1.next();
            if (animation.hasFinished()) {
                it1.remove();
            }
            animation.gameTick();
        }
        profiler.func_76319_b();
        profiler.func_76319_b();
    }

    @Override
    public void processFrame(float deltaRenderTime) {
        this.playingAnimations.values().forEach(anim -> anim.renderTick(deltaRenderTime));
    }

    @Override
    public void animateStage(AnimationStage stage, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay) {
        IProfiler profiler = Minecraft.func_71410_x().func_213239_aq();
        profiler.func_76320_a("animationRender");
        this.playingAnimations.values().forEach(anim -> anim.animate(stage, matrix, buffer, light, overlay));
        profiler.func_76319_b();
    }

    private <A extends IAnimation> void tickScheduled() {
        Iterator<Schedule<ScheduledAnimation<?>>> iterator = this.scheduledAnimations.iterator();
        while (iterator.hasNext()) {
            Schedule<ScheduledAnimation<?>> schedule = iterator.next();
            if (schedule.done()) {
                iterator.remove();
                ScheduledAnimation<?> scheduledAnimation = schedule.get();
                AnimationType<?> type = scheduledAnimation.getType();
                Object animation = scheduledAnimation.getAnimation();
                this.insert(type, (A)animation);
                continue;
            }
            schedule.update();
        }
    }
}

